class DCStats(object):
    def __init__(self):
        self.total = 0
        self.local = 0
        self.cross = 0

    def update(self, num_bytes, is_local):
        self.total += num_bytes
        if is_local:
            self.local += num_bytes
        else:
            self.cross += num_bytes

    def local_ratio(self):
        if self.total == 0:
            return 0
        return self.local / float(self.total)

    def cross_ratio(self):
        if self.total == 0:
            return 0
        return self.cross / float(self.total)

    def __str__(self):
        return "Total: %d, Local: %d, Cross: %d, LocalRatio: %f, CrossRatio: %f" % (
            self.total, self.local, self.cross, self.local_ratio(), self.cross_ratio())
