import collections

from functools import total_ordering


@total_ordering
class LocalityPeerQueue(object):
    def __init__(self):
        self._loc = collections.deque()
        self._nloc = collections.deque()
        self._cnt = 0

    def append(self, peer):
        if peer.is_local:
            self._loc.append(peer)
        else:
            self._nloc.append(peer)

    def next(self):
        try:
            # every 3rd peer should be local, count from 0
            if self._cnt % 3 == 0:
                ret = self._loc.popleft()
            else:
                ret = self._nloc.popleft()
            self._cnt += 1
            return ret
        except IndexError:
            return self._loc.popleft() if self._loc else self._nloc.popleft()

    def remove(self, peer):
        if peer.is_local:
            self._loc.remove(peer)
        else:
            self._nloc.remove(peer)

    def __len__(self):
        return len(self._loc) + len(self._nloc)

    # Define an ordering for PeerPriorityQueue to work properly.
    # It's enough for LocalityPeerQueue to be >= an empty list.
    def __lt__(self, other):
        if isinstance(other, LocalityPeerQueue):
            return id(self) < id(other)
        else:
            return False

    def __eq__(self, other):
        if isinstance(other, LocalityPeerQueue):
            return id(self) == id(other)
