import mmap

from gevent.queue import PriorityQueue


class SharedMemory(object):
    def __init__(self):
        self.mem = None
        self._created = False
        self._mmap = False
        self.pieces = 0
        self.free_queue = PriorityQueue()
        self.free_set = set()
        self.size = 0
        self.key = None

    def create_mmap(self, size):
        assert size % (4 * 1024 * 1024) == 0

        self.mem = []

        for i in range(size / (4 * 1024 * 1024)):
            # self.mem.append(MmapSegment(i, mmap.mmap(-1, 4 * 1024 * 1024)))
            self.mem.append(mmap.mmap(-1, 4 * 1024 * 1024))

        self._split_segments()

    def _split_segments(self):
        self.size = sum([len(m) for m in self.mem])
        self.pieces = int(self.size // (4 * 1024 * 1024))

        for idx in range(self.pieces):
            if idx not in self.free_set:
                self.free_queue.put(idx)
                self.free_set.add(idx)

    def get_segment(self, block=False):
        if not block and self.free_queue.qsize() == 0:
            return

        idx = self.free_queue.get()
        self.free_set.discard(idx)

        segment = MmapSegment(idx, self.mem[idx])

        return segment

    def put_segment(self, segment):
        if segment.idx not in self.free_set:
            segment.release()  # will break mem reference and all reads/writes will not be possible anymore
            self.free_set.add(segment.idx)
            self.free_queue.put(segment.idx)


class MmapSegment(object):
    def __init__(self, idx, mem):
        self.idx = idx
        self.mem = mem
        self.size = 0
        self.offset = 0

    def read(self, n=0):
        data = self.peek(n)
        self.offset += len(data)
        return data

    def peek(self, n=0):
        assert self.mem is not None, 'Attempt to read from freed memory segment (idx %d)' % (self.idx, )

        if n == 0:
            boundary = self.size
        else:
            boundary = min(self.size, self.offset + n)
        return self.mem[self.offset:boundary]


    def write(self, data):
        assert self.mem is not None, 'Attempt to write to freed memory segment (idx %d)' % (self.idx, )

        datalen = len(data)

        self.mem[self.offset:self.offset + datalen] = data
        self.offset += datalen
        self.size += datalen

    def rewind(self):
        self.offset = 0

    def release(self):
        self.mem = None
