"""
RPC errors classification.
"""


class RPCError(Exception):
    """
    Any RPC-related error or generic library error.
    """
    def __str__(self):
        strfunc = super(Exception, self).__str__
        return {
            0: lambda self: strfunc(),
            1: lambda self: strfunc(),
            2: lambda self: '[%s] %s' % (self.args[1], self.args[0]),
            3: lambda self: '[%s.%d] %s' % (self.args[1], self.args[2], self.args[0]),
            4: lambda self: '[%s.%d] %s %r' % (self.args[1], self.args[2], self.args[0], self.args[3])
        }[len(self.args)](self)


class ProtocolError(RPCError):
    """
    Protocol-level internal error (i.e., client or server sent unacceptable data).
    """


class Timeout(RPCError):
    """
    Any operation timeout error.
    """


class HandshakeError(RPCError):
    """
    Initial server handshake problem.
    """


class HandshakeTimeout(HandshakeError, Timeout):
    """
    Initial server handshake timeout.
    """


class CallError(RPCError):
    """
    Any problem related to remote call processing.
    """


class CallFail(RPCError):
    """
    Exception during method run.
    """


class CallTimeout(CallError, Timeout):
    """
    Remote call processing timed out.
    """
