def rpc_sock(workdir):
    import os

    sock_path = os.environ.get('SKYBONE_RPC_SOCK')
    if not sock_path:
        sock_path = workdir + '/rpc.sock'
    return sock_path


def make_api(workdir, libdir):
    import sys
    import types
    import pkg_resources

    for name, path in (
        ('ya', None),
        ('ya.skynet', None),
        ('ya.skynet.services', None),
        (
            'ya.skynet.services.skybone',
            libdir + '/skybone'
        ),
    ):
        mod = sys.modules.setdefault(name, types.ModuleType(name))
        modpath = mod.__dict__.setdefault('__path__', [])
        if path and path not in modpath:
            modpath.append(path)

        if '.' in name:
            base, this = name.rsplit('.', 1)
            setattr(sys.modules[base], this, mod)

        pkg_resources.declare_namespace(name)

    from ya.skynet.services.skybone.client.proxy import Copier
    return Copier(sock=rpc_sock(workdir))


def make_rpc(workdir, libdir):
    make_api(workdir, libdir)

    from ya.skynet.services.skybone.rpc.client import RPCClient
    return RPCClient(rpc_sock(workdir), None)
