def make_api(workdir, libdir):
    import sys
    import types
    import pkg_resources

    for name, path in (
        ('ya', None),
        ('ya.skynet', None),
        ('ya.skynet.services', None),
        (
            'ya.skynet.services.skybone_mds',
            libdir + '/skybone_mds'
        ),
    ):
        mod = sys.modules.setdefault(name, types.ModuleType(name))
        modpath = mod.__dict__.setdefault('__path__', [])
        if path and path not in modpath:
            modpath.append(path)

        if '.' in name:
            base, this = name.rsplit('.', 1)
            setattr(sys.modules[base], this, mod)

        pkg_resources.declare_namespace(name)


def make_rpc(workdir, libdir):
    make_api(workdir, libdir)

    from ya.skynet.services.skybone_mds.rpc.client import RPCClient
    return RPCClient(workdir + '/rpc.sock', None)
