#!/bin/sh -e
HERE=$(dirname `readlink -f $0`)

YTWHL_FILE="yandex_yt-0.8.1.post0-py2.py3-none-any.whl"
YTWHL_URL="https://pypi.yandex-team.ru/repo/default/download/yandex-yt/112782/${YTWHL_FILE}"
YTWHL_MD5="bee5fb735bbe5b80e22ebc04e4b1f9ff"

bundle () {
    rm -rf ${HERE}/build
    mkdir ${HERE}/build
    (cd ${HERE}/build; wget ${YTWHL_URL})
    [ "`md5sum ${HERE}/build/${YTWHL_FILE} | cut -d' ' -f1`" = "${YTWHL_MD5}" ] || exit 1
    rm -rf ${HERE}/snapshot
    mkdir ${HERE}/snapshot
    unzip ${HERE}/build/${YTWHL_FILE} 'yt/*.py' -d snapshot
    cp -r ${HERE}/skybone_yt ${HERE}/snapshot
    cp ${HERE}/ctl.py ${HERE}/snapshot
    cp ${HERE}/*.scsd ${HERE}/snapshot
}

case "$1" in
    bundle*)
        bundle
        exit 0
        ;;
esac
