class Ctl(object):
    def name(self):
        return 'skybone_yt'

    def start(self):
        import sys
        import os
        import api
        import library.config
        from kernel.util.sys.user import UserPrivileges

        skynet_path = os.path.dirname(os.path.dirname(api.__file__))

        svcconfig = library.config.query('skynet.services.skybone_yt',
                                         'config')
        common_args = (
            '--skynet-logging',
            '--yt-access-token-file', svcconfig['api']['yt_access_token_file'],
            '--mongodb-uri', svcconfig['api']['mongo']
        )
        api_args = (
            sys.executable, '-m', 'skybone_yt.api',
            '--listen-address', svcconfig['api']['wsgi_listen_address'],
            '--listen-port', svcconfig['api']['wsgi_listen_port'],
        ) + common_args
        gc_args = (
            sys.executable, '-m', 'skybone_yt.gc',
            str(svcconfig['gc'].get('min_age', 3600)), '--foreground',
        ) + common_args
        env = {'PYTHONPATH': ':'.join((self.resolvePath('.'), skynet_path))}
        with UserPrivileges():
            self.createProcess(gc_args, env=env, afterlife=0,
                               logStderr=True, liner=True)
            self.createProcess(api_args, env=env, afterlife=0,
                               logStderr=True, liner=True)

    def running(self):
        return self.haveRunningProcesses()

    def stop(self):
        from kernel.util.sys.user import UserPrivileges

        with UserPrivileges():
            for pp in self.spawnedProcesses():
                pp.send_signal('SIGINT')
