from __future__ import absolute_import

import argparse
import logging

from flask.config import Config


def make_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('-m', '--mongodb-uri', required=True,
                        help='mongodb connection string (without '
                             'database name)')
    parser.add_argument('-Y', '--yt-access-token-file', required=True,
                        type=argparse.FileType('r'),
                        help='read yt access token from a given file')
    parser.add_argument('--skynet-logging', action='store_true',
                        help='use SkynetLoggingHandler (requires skynet '
                             'path in PYTHONPATH)')
    return parser


def parse_args(parser):
    args = parser.parse_args()
    if not args.skynet_logging:
        logging.basicConfig(
            level=logging.DEBUG,
            format='%(asctime)-15s %(name)s %(levelname)s %(message)s'
        )
    else:
        from api.logger import SkynetLoggingHandler
        handler = SkynetLoggingHandler(app="skybone_yt",
                                       filename="skybone_yt.log")
        logging.root.addHandler(handler)
        logging.root.setLevel(logging.INFO)

    config = Config('.')
    config.from_object('skybone_yt.config')
    config['MONGODB_URI'] = args.mongodb_uri
    config['YT_ACCESS_TOKEN'] = args.yt_access_token_file.read().strip()
    args.yt_access_token_file.close()
    return config, args
