import hashlib

import yt.wrapper as yt


CHUNK_SIZE = 4 * 1024 * 1024


def make_client(proxy_url, access_token):
    return yt.YtClient(config={
        'proxy': {'url': proxy_url},
        'token': access_token

    })


def read_file_by_chunks(client, path):
    response_stream = client.read_file(path)
    try:
        while True:
            chunk = response_stream.read(CHUNK_SIZE)
            if not chunk:
                break
            yield chunk
    finally:
        response_stream.close()


def get_file_size_and_checksums(client, path):
    chunk_hashes = []
    whole_file_hash = hashlib.md5()
    file_size = 0
    for chunk in read_file_by_chunks(client, path):
        whole_file_hash.update(chunk)
        chunk_hashes.append(hashlib.sha1(chunk).digest())
        file_size += len(chunk)
    return file_size, whole_file_hash.hexdigest(), chunk_hashes


def check_file_exists(client, path):
    return client.exists(path)
