#!/usr/bin/env python
from __future__ import absolute_import

import time

from pymongo import MongoClient

from skybone_yt.model import MongoStorage
from skybone_yt import cypress
import skybone_yt.args
import skybone_yt.share


def gc(config, storage, min_age):
    cypress_client_by_proxy = {}
    for file_info in storage.get_stale_files(min_age):
        client = cypress_client_by_proxy.get(file_info['proxy'])
        if client is None:
            client = cypress.make_client(file_info['proxy'],
                                         config['YT_ACCESS_TOKEN'])
            cypress_client_by_proxy[file_info['proxy']] = client
        file_exists = cypress.check_file_exists(client, file_info['path'])
        if not file_exists:
            skybone_yt.share.remove(config, storage,
                                    file_info['proxy'], file_info['path'])


def main():
    parser = skybone_yt.args.make_parser()
    parser.add_argument('min_age', default=3600, type=int,
                        help='minimum time since last check, seconds. '
                             'default is one hour')
    parser.add_argument('-f', '--foreground', action='store_true',
                        help='stay in foreground and run checks every 30 secs')
    config, args = skybone_yt.args.parse_args(parser)
    mongoclient = MongoClient(config['MONGODB_URI'])
    storage = MongoStorage(mongoclient, config['MONGODB_DB_NAME'])
    gc(config, storage, args.min_age)
    if args.foreground:
        while True:
            time.sleep(30)
            gc(config, storage, args.min_age)


if __name__ == '__main__':
    main()
