import time

import pymongo
from bson.objectid import ObjectId


class MongoStorage(object):
    def __init__(self, client, dbname):
        self.client = client
        self.dbname = dbname
        self.db = self.client[self.dbname]
        self._create_indexes()

    def _create_indexes(self):
        self.db.files.create_index(
            [('proxy', pymongo.ASCENDING),
             ('path', pymongo.ASCENDING)],
            unique=True
        )
        self.db.files.create_index(
            [('last_checked', pymongo.DESCENDING)],
        )

    def save_file_info(self, proxy, path, rbtorrent_id):
        fltr = {'proxy': proxy, 'path': path}
        update = {'$set': {'last_checked': time.time()},
                  '$addToSet': {'torrents': rbtorrent_id}}
        self.db.files.update(fltr, update, upsert=True)
        return str(self.db.files.find_one(fltr, {'_id': True})['_id'])

    def update_file_last_checked(self, proxy, path):
        fltr = {'proxy': proxy, 'path': path}
        update = {'$set': {'last_checked': time.time()}}
        self.db.files.update(fltr, update)

    def get_file_info(self, file_id):
        fltr = {'_id': ObjectId(file_id)}
        prj = {'_id': False, 'proxy': True, 'path': True}
        return self.db.files.find_one(fltr, prj)

    def remove_file(self, proxy, path):
        fltr = {'proxy': proxy, 'path': path}
        result = self.db.files.find_one(fltr, {'torrents': True})
        if not result:
            return []
        self.db.files.remove(fltr)
        return result['torrents']

    def get_stale_files(self, min_age):
        fltr = {'last_checked': {'$lt': time.time() - min_age}}
        prj = {'proxy': True, 'path': True, '_id': False}
        return self.db.files.find(fltr, prj,
                                  sort=[('last_checked', pymongo.DESCENDING)])
