import logging

from skybone_yt import cypress, skybone
from skybone_yt.mocksoul_rpc.client import RPCClient


def make_yt_rbtorrent(access_token, proxy, paths):
    client = cypress.make_client(proxy, access_token)
    files = {}
    checksums = {}
    md5_by_path = {}
    for path in paths:
        assert path.startswith('//')
        relpath = path[2:]
        size, md5, chunk_hashes = cypress.get_file_size_and_checksums(client,
                                                                      path)
        files[relpath] = {
            'md5': md5,
            'executable': False,
            'size': size,
        }
        checksums[md5] = ''.join(chunk_hashes)
        md5_by_path[path] = md5

    rbtorrent_id, head = skybone.generate_resource(files, checksums)
    return md5_by_path, rbtorrent_id, head


def announce_rbtorrent_to_mds(rpc_socket_path, rbtorrent, head, info):
    cli = RPCClient(rpc_socket_path, None)
    job = cli.call('add_resource', rbtorrent, head, info)
    assert job.wait(), 'Skybone refused to add resource'


def share(config, storage, proxy, paths):
    md5_by_path, rbtorrent_id, head = make_yt_rbtorrent(
        config['YT_ACCESS_TOKEN'], proxy, paths
    )
    id_map = {}
    for path in paths:
        file_id = storage.save_file_info(proxy, path, rbtorrent_id)
        id_map[md5_by_path[path]] = file_id
    mds_info = {'id_map': id_map}
    logger = logging.getLogger('skybone_yt.share')
    logger.info('sharing rbtorrent %s, mds info is %r', rbtorrent_id, mds_info)
    announce_rbtorrent_to_mds(config['SKYBONE_MDS_RPC_SOCK'],
                              rbtorrent_id, head, mds_info)
    return rbtorrent_id


def remove(config, storage, proxy, path):
    torrent_ids = storage.remove_file(proxy, path)
    logger = logging.getLogger('skybone_yt.share')
    logger.info('removing file %s @ %s, torrent_ids containing it are %s',
                path, proxy, torrent_ids)
    cli = RPCClient(config['SKYBONE_MDS_RPC_SOCK'], None)
    for torrent_id in torrent_ids:
        job = cli.call('remove_resource', torrent_id)
        if not job.wait():
            logger.warning('couldn\'t deannounce %s', torrent_id)
