import sys

PY3 = sys.version_info.major > 2


class Bencached(object):

    __slots__ = ['bencoded']

    def __init__(self, s):
        self.bencoded = s


def encode_bencached(x, r):
    r.append(x.bencoded)


def encode_int(x, r):
    if PY3:
        inum = bytes(str(x), 'ascii')
    else:
        inum = str(x)

    r.extend((b'i', inum, b'e'))


def encode_bool(x, r):
    if x:
        encode_int(1, r)
    else:
        encode_int(0, r)


def encode_bytes(x, r):
    if PY3:
        kl = bytes(str(len(x)), 'ascii')
    else:
        kl = str(len(x))

    r.extend((kl, b':', x))


def encode_string(x, r):
    encode_bytes(bytes(x, 'ascii'), r)


def encode_list(x, r):
    r.append(b'l')
    for i in x:
        encode_func[type(i)](i, r)
    r.append(b'e')


def encode_dict(x, r):
    r.append(b'd')
    ilist = sorted(x.items())
    for k, v in ilist:
        if PY3:
            if isinstance(k, str):
                k = bytes(k, 'ascii')
        assert isinstance(k, bytes)

        if PY3:
            kl = bytes(str(len(k)), 'ascii')
        else:
            kl = str(len(k))

        r.extend((kl, b':', k))
        encode_func[type(v)](v, r)
    r.append(b'e')


encode_func = {}
encode_func[Bencached] = encode_bencached
encode_func[str] = encode_string
encode_func[bytes] = encode_bytes
encode_func[int] = encode_int
encode_func[list] = encode_list
encode_func[tuple] = encode_list
encode_func[dict] = encode_dict
encode_func[bool] = encode_bool


def bencode(x):
    r = []
    encode_func[type(x)](x, r)
    return b''.join(r)
