package api

import (
	"encoding/hex"

	"github.com/zeebo/bencode"
)

// var skippedTypes = map[string]struct{}{
// 	"touch":   {},
// 	"symlink": {},
// 	"mkdir":   {},
// }

func FixHead(head interface{}) {
	// in python3 default encoding for 'str' type is utf-8, thus pieces and md5sums should be represented
	// as []byte to avoid decoding errors in py3 msgpack module
	// looks abysmal, but other ways to fix this are quite hefty

	for _, properties := range head.(map[string]interface{})["structure"].(map[string]interface{}) {
		// fileType := properties.(map[string]interface{})["resource"].(map[string]interface{})["type"]
		if t, ok := properties.(map[string]interface{})["md5sum"].(string); ok {
			bytesum := []byte(t)
			properties.(map[string]interface{})["md5sum"] = bytesum
		}
	}

	for _, properties := range head.(map[string]interface{})["torrents"].(map[string]interface{}) {
		if t, ok := properties.(map[string]interface{})["info"].(map[string]interface{})["pieces"].(string); ok {
			bytesum := []byte(t)
			properties.(map[string]interface{})["info"].(map[string]interface{})["pieces"] = bytesum
		}
	}
}

func ValidateHead(head interface{}) error {
	// fmt.Printf("HEAD: %#v\n", head)
	// fmt.Printf("\n%T\n\n", head.(map[string]interface{})["structure"].(map[string]interface{})["t.py"].(map[string]interface{})["md5sum"])
	return nil
}

func DecodeHead(phead string) (head interface{}, err error) {
	//hex
	buf, err := hex.DecodeString(phead)
	if err != nil {
		return nil, err
	}
	//bencode
	err = bencode.DecodeBytes(buf, &head)
	if err != nil {
		return nil, err
	}
	return head, nil
}
