package api

import (
	"reflect"
	"testing"
)

func TestSetOpts(t *testing.T) {
	correctLinks := map[Hash]map[Link]LinkOpts{
		"samplehash": {
			"http://m.com/sample": {
				"Range": "bytes=512-517",
			},
		},
	}
	setCorrectLinks := map[Hash]map[Link]LinkOpts{
		"samplehash": {
			"http://m.com/sample": {
				"0": "anno",
				"1": "bytes=512-517",
			},
		},
	}

	wrongRangeLinks := map[Hash]map[Link]LinkOpts{
		"samplehash": {
			"http://m.com/sample": {
				"Range": "bytes=12",
			},
		},
	}

	linkobj := Info{}
	err := linkobj.Parse(correctLinks)
	if err != nil {
		t.Fatalf("correct links: %v", err)
	}

	genopts := LinkOpts{
		"SourceId": "anno",
	}

	err = linkobj.SetOpts(genopts)
	if err != nil {
		t.Fatalf("correct links opts: %v", err)
	}

	if !reflect.DeepEqual(linkobj.Links, setCorrectLinks) {
		t.Fatalf("expected %v, received %v", setCorrectLinks, linkobj.Links)
	}

	err = linkobj.Parse(wrongRangeLinks)
	if err != nil {
		t.Fatalf("malformed links: %v", err)
	}

	err = linkobj.SetOpts(genopts)
	if err == nil {
		t.Fatalf("malformed links opts: %v", err)
	}

}
