package api

import (
	"bytes"

	"github.com/jackc/pgx/v4"
	"github.com/vmihailenco/msgpack/v4"
)

type Resource struct {
	UID       string
	Type      string
	Head      map[string]interface{}
	Info      map[Hash]map[Link]LinkOpts
	Mode      string
	Owner     string
	TScreated uint64
	TSused    uint64
}

func NewResourceFromRow(row pgx.Row) (*Resource, error) {
	res := Resource{}
	var PackedHead, PackedInfo []byte
	err := row.Scan(&res.UID, &res.Type, &PackedHead, &PackedInfo, &res.Mode, &res.Owner, &res.TScreated, &res.TSused)
	if err != nil {
		return nil, err
	}
	var Head interface{}
	//to prevent int8/int16 from popping out, since structpb does not support it: https://github.com/golang/protobuf/issues/1463
	//use custom decoder with loose decoding
	dec := msgpack.NewDecoder(bytes.NewReader(PackedHead))
	dec.UseDecodeInterfaceLoose(true)
	err = dec.Decode(&Head)
	if err != nil {
		return nil, err
	}
	res.Head = Head.(map[string]interface{})
	info := Info{}
	err = info.Parse(PackedInfo)
	if err != nil {
		return nil, err
	}
	res.Info = info.Links
	return &res, nil
}
