package auth

import (
	"errors"
	"flag"

	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"

	yazap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmauth"
)

type RequestID struct{}

var (
	TVMToken   string
	TVMPort    int
	TVMDisable bool
)

func TVMFlags() {
	flag.StringVar(&TVMToken, "tvm-token", "", "database host")
	flag.IntVar(&TVMPort, "tvm-port", 18080, "tvm client port")
	flag.BoolVar(&TVMDisable, "tvm-disable", false, "turns off tvm auth")
}

func TVMSetup(logcore zapcore.Core) (*tvmauth.Client, error) {

	l := yazap.NewWithCore(logcore, zap.AddCaller())
	tvm, err := tvmauth.NewToolClient(tvmauth.TvmToolSettings{
		Alias:     "skyboned",
		AuthToken: TVMToken,
		Port:      TVMPort,
	}, l)
	if err != nil {
		return nil, err
	}
	return tvm, nil
}

func CheckTVMID(resourceOwnerID int, OwnerID int) bool {
	if resourceOwnerID == OwnerID {
		return true
	}

	if OwnerID == 1 && resourceOwnerID == 3 {
		return true
	}

	if OwnerID == 3 && resourceOwnerID == 1 {
		return true
	}
	return false
}

var (
	ErrTVMAuthMissing = errors.New("tvm: missing ticket")
	ErrTVMAuthFailed  = errors.New("tvm: forbidden")
)
