package skyboned

import (
	"net/http"

	pb "a.yandex-team.ru/infra/skyboned/go/skyboned_rpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

var (
	errorHTTPtoCode = map[int32]codes.Code{
		int32(http.StatusBadRequest):          codes.InvalidArgument,
		int32(http.StatusForbidden):           codes.PermissionDenied,
		int32(http.StatusInternalServerError): codes.Internal,
		int32(http.StatusServiceUnavailable):  codes.Unavailable,
		int32(http.StatusNotFound):            codes.NotFound,
	}
)

// wraps error to properly represent http status code
func ErrorWrapper(code int32, err error, message ...string) (*pb.Status, error) {
	var m string
	if len(message) == 0 {
		m = err.Error()
	} else {
		m = message[0]
	}
	return &pb.Status{Code: code, Message: m}, status.Error(errorHTTPtoCode[code], err.Error())
}
