package util

import (
	"os"
	"strconv"
	"strings"

	"github.com/gofrs/uuid"
)

func EnvVar(envVar string) string {
	if strings.HasPrefix(envVar, "env:") {
		ret := os.Getenv(strings.TrimPrefix(envVar, "env:"))
		return ret
	}
	return envVar
}
func GenerateRequestID() (requestID string) {
	uid, _ := uuid.NewV4()
	requestID = uid.String()[:8]
	return
}
func CheckRange(lRange string, rRange string) bool {
	nLRange, err := strconv.Atoi(lRange)
	if err != nil {
		return false
	}
	nRRange, err := strconv.Atoi(rRange)
	if err != nil {
		return false
	}
	return nLRange <= nRRange
}
