import time

from infra.skyboned.src.model import Resource


class Lookup(object):
    def __init__(self, db, db_ro, dbt):
        self.db = db
        self.db_ro = db_ro
        self.dbt = dbt

        self.cache = {}  # uid => (head, links, ttl)

        self.cache_clean_ts = time.time()

    def look_head(self, uid):
        # Should return head (bencoded string) and extra (dict, for idmap mode)
        # or (None, None)
        print('look head', uid)

        self.clean_cache()

        if uid not in self.cache:
            resource = Resource(self.db, self.db_ro, self.dbt, uid)
            if not resource.load():
                print('not found')
                return None, None
            self.cache[uid] = (resource.head, resource.info, time.time() + 60)

        return self.cache[uid][0], None

    def get_link(self, uid, md5, head=None):
        self.clean_cache()

        if uid not in self.cache:
            if self.look_head(uid)[0] is None:
                return None

        if md5 in self.cache[uid][1]:
            return self.cache[uid][1][md5]

    def clean_cache(self):
        now = time.time()
        if now - self.cache_clean_ts > 60:
            drop = set()
            for uid, (head, info, ttl) in self.cache.items():
                if ttl < now:
                    drop.add(uid)

            for uid in drop:
                self.cache.pop(uid)

            self.cache_clean_ts = now
