#!/bin/bash

cd "$(dirname "$0")"

RANDOM=$(date +%s)

SIZE_IN_MB=$((100 + $RANDOM % 100))
NAME=test.data
NGINX_PATH=/var/www/html/skyboned/files/$NAME
CLIENT=./skyboned-client
TVM_ID=
TVM_SECRET=
TIMEOUT=30
HOST=$(hostname)
RESID=""

client() {
    $CLIENT --server skyboned-api-prestable-1.sas.yp-c.yandex.net --tvm-id $TVM_ID --tvm-secret $TVM_SECRET $@
}

cleanup() {
    rm -f $NGINX_PATH $NAME
}

juggler_error() {
    ERR=$1
    curl -s -d "{\"events\":[{\"service\":\"skyboned-tester\",\"host\":\"$HOST\",\"status\":\"CRIT\",\"description\":\"$ERR\"}]}" juggler-push.search.yandex.net/events >/dev/null 2>&1
}

juggler_ok() {
    curl -s -d "{\"events\":[{\"service\":\"skyboned-tester\",\"host\":\"$HOST\",\"status\":\"OK\",\"description\":\"Test passed\"}]}" juggler-push.search.yandex.net/events >/dev/null 2>&1
}

error() {
    ERR=$1
    echo $ERR
    cleanup
    juggler_error "$ERR"
    if [[ -n $RESID ]]; then
        client del $RESID >/dev/null 2>&1
    fi
    exit 1
}

cleanup

dd if=/dev/urandom of=$NGINX_PATH bs=1M count=$SIZE_IN_MB >/dev/null 2>&1

printf "Sharing file of size $SIZE_IN_MB MB: "
RESID=$(client add /var/www/html/skyboned/files/test.data)
if [[ $? != 0 ]]; then
    error "Failed to share resource in skyboned"
fi
echo $RESID

printf "Downloading file: "
sky get -N Backbone -t $TIMEOUT $RESID
if [[ $? != 0 ]]; then
    error "Failed to download file in $TIMEOUT seconds"
fi
echo "OK"

printf "Checking downloaded file: "
cmp $NAME $NGINX_PATH
if [[ $? != 0 ]]; then
    error "Downloaded file differs from original!"
fi
echo "OK"

cleanup

printf "Deleting resource: "
client del $RESID >/dev/null 2>&1
if [[ $? != 0 ]]; then
    error "Failed to delete resource from skyboned"
fi
echo "OK"

printf "Checking that removed resource is unavailable: "
sky get -N Backbone -t $TIMEOUT $RESID >/dev/null 2>&1
# api.copier.Timeout
if [[ $? != 5 ]]; then
    error "Failed to download file in $TIMEOUT seconds"
fi
echo "OK"

cleanup
juggler_ok
