#!/usr/bin/env python3

import argparse
import sys

from infra.skyboned.src.db import Database, add_db_arguments
from infra.skyboned.src.model import Resource


def parse_args():
    parser = argparse.ArgumentParser()
    add_db_arguments(parser)
    parser.add_argument('--resid', default=[], nargs='+', action='extend')
    parser.add_argument('--res-file')
    return parser.parse_args()


def main():
    args = parse_args()

    db = Database(
        host=args.db_host,
        port=args.db_port,
        user=args.db_user,
        password=args.db_password,
        dbname='skyboned'
    )

    db.connect(autocommit=True, read_write=False)

    uids = args.resid
    if args.res_file:
        with open(args.res_file) as f:
            for line in f:
                uids.append(line.strip())

    for idx, uid in enumerate(uids):
        print('%d/%d\r' % (idx + 1, len(uids)), file=sys.stderr, end='')
        resource = Resource(db, db, db, uid)
        if resource.load():
            print(resource)
        else:
            print('Resource %s not found!' % uid)
        print()

if __name__ == '__main__':
    main()
