from __future__ import absolute_import

import os
from py import std

from .kernel_util.functional import singleton


@singleton
def initialize_skycore():
    # We have some spurious bugs with std::runtime_error and FreeBSD if
    # non-C locale defined..
    os.environ['LANG'] = 'C'
    os.environ['LC_ALL'] = 'C'

    # These imports here is to avoid importing gevent then importing
    # whole skycore package.

    import gevent

    from .framework.greenlet import Greenlet

    std.sys.modules['gevent'].Greenlet = Greenlet
    std.sys.modules['gevent.greenlet'].Greenlet = Greenlet

    for attr in (
        'Greenlet',
        'spawn',
        'spawn_later',
        'spawn_link',
        'spawn_link_value',
        'spawn_link_exception',
    ):
        if hasattr(Greenlet, attr):
            setattr(std.sys.modules['gevent'], attr, getattr(Greenlet, attr))
            setattr(std.sys.modules['gevent.greenlet'].Greenlet, attr, getattr(Greenlet, attr))

    from .framework.utils import getaddrinfo_g, gethostbyaddr_g
    import gevent.socket
    import _socket

    gevent.socket.gethostbyaddr = lambda *args, **kwargs: (
        kwargs.update({'gethostbyaddr': _socket.gethostbyaddr}) or gethostbyaddr_g(*args, **kwargs)
    )
    gevent.socket.getaddrinfo = lambda *args, **kwargs: (
        kwargs.update({'getaddrinfo': _socket.getaddrinfo}) or getaddrinfo_g(*args, **kwargs)
    )
