import os

import six

from ..framework.component import Component


class PortoWatcher(Component):
    def __init__(self, conn, parent):
        super(PortoWatcher, self).__init__(parent=parent, logname='porto  ')
        self.conn = conn
        self.procs = set()

    def stop(self):
        super(PortoWatcher, self).stop()
        if os.path.exists("/run/portod.socket"):
            self.conn.disconnect()
            if hasattr(self.conn, 'stop'):
                self.conn.stop()
        return self

    @Component.green_loop(logname='wtchr')
    def _watcher(self, log):
        if not os.path.exists("/run/portod.socket"):
            return 60 * 60

        try:
            conts = self.conn.Get(['***'], ['private', 'state'])
            if not isinstance(conts, dict):
                log.warning('porto connection appears to be in invalid state, need to reconnect')
                self.conn.disconnect()
                return 5
        except Exception:
            conts = {}

        for name, props in six.iteritems(conts):
            if not isinstance(props, dict) or 'private' not in props or 'state' not in props:
                log.warning('porto connection appears to be in invalid state, need to reconnect')
                self.conn.disconnect()
                return 5

            private = props['private']
            state = props['state']
            short_name = name.split('/')[-1]

            if (
                (private != 'SKYCORE' and not short_name.startswith('skycore-'))
                or state in ('meta',)
            ):
                continue

            uuid = short_name[8:]  # strip 'skycore-'
            if uuid not in self.procs:
                log.debug('killing old container %r (state=%r, private=%r)', name, state, private)
                try:
                    self.conn.Stop(name)
                except Exception:
                    pass

                try:
                    self.conn.Destroy(name)
                except Exception:
                    pass

        return 300

    def __str__(self):
        return "%s on %s" % (self.__class__.__name__, self.conn)
