def is_component(n):
    from skycore.framework.component import Component
    return isinstance(n, Component)


components = filter(is_component, __import__('gc').get_objects())
children = __import__('itertools').chain.from_iterable(component.childs for component in components)
components = set(components) - set(children)


def print_component_tree(next, component, shift=0):
    print " " * shift, component
    shift += 2
    for loopfn, loop in component.loops.iteritems():
        print " " * shift, loopfn, "(MISSING)" if loop is None else "(STOPPED)" if loop.ready() else "(ACTIVE)"
    print ""

    for child in component.childs:
        next(next, child, shift)


for component in components:
    print_component_tree(print_component_tree, component)
