from __future__ import absolute_import

from functools import partial
import weakref

import gevent.event
import gevent.queue


class Event(gevent.event.Event):
    def link_event(self, event):
        def link(_eventref, *args, **kwargs):
            _event = _eventref()
            if _event is not None:
                _event.set()

        self.rawlink(partial(link, weakref.ref(event)))
