from __future__ import absolute_import

import os
from .framework.utils import Path

import six


def path_parts(path):
    parts = path.split(os.path.sep)
    for start in six.moves.xrange(len(parts)):
        yield os.path.sep.join(parts[:start]), os.path.sep.join(parts[start:])


def fix_path(path, base, old_base):
    if not isinstance(path, str) or not os.path.isabs(path):
        return path, old_base

    if old_base is not None:
        if path.startswith(old_base):
            new_path = Path(path).relto(old_base)
            if new_path.startswith('namespaces/'):
                new_path = 'ns/' + new_path[11:]
            return new_path, old_base
        else:
            return path, old_base

    for candidate_base, candidate in path_parts(path):
        if candidate.startswith('namespaces/'):
            candidate = 'ns/' + candidate[11:]

        if base.join(candidate).check(exists=1):
            return candidate, candidate_base

    return path, old_base


def fixup_state(base, state):
    old_base = None
    base = Path(base)

    for ns_key, ns_cfg in state.iteritems():
        # first we fix rundir to detect old_base and be able to perform renames
        if ns_key == '__version__':
            continue

        ns_cfg['rundir'], old_base = fix_path(ns_cfg['rundir'], base, old_base)
        ns_cfg['workdir'], old_base = fix_path(ns_cfg['workdir'], base, old_base)
        for srvc in ns_cfg['services']:
            srvc['cfg']['basepath'], old_base = fix_path(srvc['cfg']['basepath'], base, old_base)
            for proc in filter(lambda x: x['type'] == 'liner', srvc['procs']):
                proc['rundir'], old_base = fix_path(proc['rundir'], base, old_base)
