from collections import deque

import six


class Stream(object):
    __slots__ = ['last_val', 'stream', 'len', 'log', 'mark']

    def __init__(self, log, mark):
        self.log = log
        self.mark = mark
        self.last_val = ''
        self.stream = deque()
        self.len = 0

    def feed(self, data):
        if not data:
            return

        self.last_val = data
        self.stream.append(data)
        self.len += len(data)

        npos = self.stream[-1].find('\n')
        msgs = []

        if npos > -1:
            n = len(self.stream) - 1
            to_append = [self.stream.popleft() for _ in six.moves.xrange(n)]
            msgs.extend(to_append)
            self.len -= sum(len(m) for m in to_append)

            msgs.append(self.stream[0][:npos])
            self.len -= len(msgs[-1]) + 1
            self.stream[0] = self.stream[0][npos + 1:]

            self.log.info("[%s] %s", self.mark, ''.join(msgs))
            msgs = []
        else:
            msglen = 0
            while self.len >= (1 << 14):
                msgs.append(self.stream.popleft())
                self.len -= len(msgs[-1])
                msglen += len(msgs[-1])
                if msglen >= (1 << 11):
                    self.log.info("[%s] %s", self.mark, ''.join(msgs))
                    msgs = []
                    msglen = 0
        if msgs:
            self.log.info("[%s] %s", self.mark, ''.join(msgs))

    def finish(self):
        msg, self.stream = ''.join(self.stream), deque()
        self.last_val = ''
        self.len = 0
        if msg:
            self.log.info("[%s] %s", self.mark, msg)


class Proc(object):  # pragma: nocoverage
    def link(self, cb):
        raise NotImplementedError

    def wait(self, timeout=None):
        raise NotImplementedError

    def kill(self):
        raise NotImplementedError

    def send_signal(self, sig):
        raise NotImplementedError

    @property
    def ready(self):
        return False

    @property
    def succeeded(self):
        return False

    @property
    def failed(self):
        return False

    @property
    def cpu_usage(self):
        return 0

    @property
    def rss(self):
        return 0

    @property
    def max_rss(self):
        return 0

    in_porto = False
    restorable = False
