import os
import fcntl


class Fd(int):
    def __del__(self):
        os.close(self)


def pipe():
    pair = os.pipe()
    for fd in pair:
        setcloexec(fd)

    return Fd(pair[0]), Fd(pair[1])


def setcloexec(fd):
    flags = fcntl.fcntl(fd, fcntl.F_GETFD)
    fcntl.fcntl(fd, fcntl.F_SETFD, flags | fcntl.FD_CLOEXEC)


def setnonblocking(fd):
    flags = fcntl.fcntl(fd, fcntl.F_GETFL)
    fcntl.fcntl(fd, fcntl.F_SETFL, flags | os.O_NONBLOCK)
