import os
from collections import deque

import gevent.socket

from ..kernel_util.functional import singleton
from . import fdtools


class MailBox(object):
    def __init__(self):
        self.rpipe, self.wpipe = fdtools.pipe()
        self.queue = deque()

    def put(self, obj):
        self.queue.append(obj)
        os.write(self.wpipe, 'c')

    def get(self):
        while not self.queue:
            gevent.socket.wait_read(self.rpipe)
            os.read(self.rpipe, 4096)

        return self.queue.popleft()

    def iterate(self):
        while True:
            yield self.get()


@singleton
def mailbox():
    return MailBox()
