from __future__ import absolute_import

import socket

import gevent
try:
    import gevent.coros as coros
except ImportError:
    import gevent.lock as coros
import gevent.event
import gevent.socket

from gevent.queue import Queue as GQueue

from .socket import Socket
from .client import BaseReactor, RPCJob, RPCClientBase


class GeventReactor(BaseReactor):
    _event_class = gevent.event.Event
    _lock_class = coros.RLock

    def _socket_maker(self, family):
        return Socket(gevent.socket.socket(family, socket.SOCK_STREAM), True)

    def __init__(self, log):
        super(GeventReactor, self).__init__(log=log)
        self._loop_grn = None

    def stop(self):
        super(GeventReactor, self).stop()
        if self._loop_grn and self._loop_grn.ready():
            self._loop_grn.join(timeout=10)
            assert not self._loop_grn.ready()

    def start(self):
        assert self._loop_grn is None
        assert self._sock is not None
        self._loop_grn = gevent.Greenlet(run=self._loop)
        self._loop_grn.start()

        super(GeventReactor, self).start()

    def _make_job(self, jid):
        return RPCJob(jid, queue_class=GQueue)

    def join(self, timeout=None):
        self._loop_grn.join(timeout=timeout)
        return self._loop_grn.ready()

    def is_active(self):
        return super(GeventReactor, self).is_active() and not self._loop_grn.ready()


class RPCClientGevent(RPCClientBase):
    _reactors_lock = coros.Semaphore()
    _reactor_class = GeventReactor
