# cython: language_level=3str, language=c++
import random
cimport cython


cdef class IntervalController(object):
    def __init__(
        self,
        double initial=0.5,
        double multiplier=2.0,
        double variance=0.,
        double maximum=30.0,
    ):
        self.initial = initial
        self.multiplier = multiplier
        self.variance = variance
        self.maximum = maximum
        self.reset()

    cpdef double schedule_next(self):
        self.interval = min(self._interval * self.multiplier, self.maximum)
        return self.interval

    @property
    def interval(self):
        return self.current

    @interval.setter
    def interval(self, double value):
        if value is None:
            self.reset()
        else:
            self._interval = value
            self.current = self._interval + (random.random() - 0.5) * 2 * self.variance * self._interval

    cpdef double reset(self):
        self.interval = self.initial
        return self.current

    def __str__(self):
        return '%s (%.3fs)' % (type(self).__name__, self.current)

    def __repr__(self):
        return '%s(initial=%f, multiplier=%f, variance=%f, maximum=%f)' % (
            type(self).__name__, self.initial, self.multiplier, self.variance, self.maximum
        )
