from libc.stdint cimport uint64_t, uint32_t
from libcpp cimport bool


cpdef loads(const unsigned char[:] data) except +

cdef class Header:
    cdef:
        readonly uint64_t magic
        readonly uint32_t format_version
        readonly uint64_t krl_version
        readonly uint64_t generated_date
        readonly uint64_t flags
        readonly bytes reserved
        readonly bytes comment


cpdef enum SectionType:
    Certificates = 1
    ExplicitKey = 2
    FingerprintSHA1 = 3
    Signature = 4
    FingerprintSHA256 = 5


cpdef enum CertificateSectionType:
    SerialList = 0x20
    SerialRange = 0x21
    SerialBitmap = 0x22
    KeyId = 0x23


cdef class Section:
    cdef readonly SectionType section_type


cdef class CertificateSubsection:
    cdef readonly CertificateSectionType section_type

    cpdef bool cert_valid(self, uint64_t serial, bytes key_id)


cdef class CertificatesSectionSerialList(CertificateSubsection):
    cdef public list serials


cdef class CertificatesSectionSerialRange(CertificateSubsection):
    cdef public uint64_t serial_min
    cdef public uint64_t serial_max


cdef class CertificatesSectionSerialBitmap(CertificateSubsection):
    cdef public uint64_t serial_offset
    cdef public bytes revoked_keys_bitmap  # TODO mpint


cdef class CertificatesSectionKeyId(CertificateSubsection):
    cdef public list key_ids


cdef class CertificatesSection(Section):
    cdef public bytes ca_key
    cdef public bytes reserved
    cdef public list cert_sections

    cpdef bool cert_valid(self, bytes ca_key, uint64_t serial, bytes key_id)


cdef class ExplicitKeySection(Section):
    cdef public list public_key_blobs

    cpdef bool key_valid(self, object key)


cdef class FingerprintSHA1Section(Section):
    cdef public list public_key_hashes

    cpdef bool key_valid(self, object key)


cdef class FingerprintSHA256Section(Section):
    cdef public list public_key_hashes

    cpdef bool key_valid(self, object key)


cdef class SignatureSection(Section):
    cdef public bytes signature_key
    cdef public bytes signature
    cdef public bytes blob


cdef class KRL:
    cdef public Header header
    cdef public list sections
    cdef public object signature

    cpdef bool cert_valid(self, object cert)
