# cython: language_level=3str, language=c++
import time

ctypedef fused numeric:
    short
    int
    float
    double


IF UNAME_SYSNAME != "Windows":
    from posix.time cimport CLOCK_MONOTONIC, timespec, clock_gettime

    cpdef public inline double monotime() nogil:
        cdef timespec ts
        clock_gettime(CLOCK_MONOTONIC, &ts)
        return <double>ts.tv_sec + <double>ts.tv_nsec / 1e9
ELSE:
    cdef extern from "util/system/datetime.h":
        uint64_t MicroSeconds()

    cpdef public inline double monotime() nogil:
        return <double>MicroSeconds() / 1e6


cpdef public void sleep(numeric seconds):
    """
    Why it's needed? In short: time.sleep doesn't guarantee,
    that it won't be interrupted (e.g. procman api constantly wakes every thread
    and interrupts time.sleep)
    """
    if seconds == 0:
        time.sleep(0)
        return

    cdef double now = monotime()
    cdef double remainder = seconds
    cdef double deadline = now + remainder
    while remainder > 0:
        time.sleep(remainder)
        now = monotime()
        remainder = deadline - now
