package pods

import (
	"time"

	"a.yandex-team.ru/yp/go/proto/ypapi"
)

type Eviction struct {
	State       ypapi.EEvictionState
	Reason      ypapi.EEvictionReason
	LastUpdated time.Time
}

type Maintenance struct {
	State ypapi.EPodMaintenanceState
}

func isEvictionRequested(eviction *Eviction, maintenance *Maintenance) bool {
	if eviction.State != ypapi.EEvictionState_ES_REQUESTED {
		return false
	}

	if eviction.Reason == ypapi.EEvictionReason_ER_HEALER {
		return false
	}

	if eviction.Reason == ypapi.EEvictionReason_ER_HFSM && maintenance.State != ypapi.EPodMaintenanceState_PMS_REQUESTED {
		// in that case eviction is not really requested
		return false
	}

	return true
}

func getPodEviction(ypPod *ypapi.TPod) *Eviction {
	return &Eviction{
		State:       ypPod.GetStatus().GetEviction().GetState(),
		Reason:      ypPod.GetStatus().GetEviction().GetReason(),
		LastUpdated: time.Unix(0, int64(ypPod.GetStatus().GetEviction().GetLastUpdated())*1000),
	}
}

func getPodMaintenance(ypPod *ypapi.TPod) *Maintenance {
	return &Maintenance{
		State: ypPod.GetStatus().GetMaintenance().GetState(),
	}
}
