package states

import (
	"fmt"

	"a.yandex-team.ru/infra/spnotifier/ticket"
)

type DeployState struct {
	StartrekerExecution *ticket.StartrekerExecution `json:"startreker_execution"`
}

type DeployTableRow struct {
	StageID string `yson:"stage_id"`
	State   []byte `yson:"state"`
}

func (r *DeployTableRow) GetState() []byte {
	return r.State
}

func (r *DeployTableRow) GetID() string {
	return r.StageID
}

type DeploySnapshot struct {
	path   string
	states map[string]*DeployState
}

func (s *DeploySnapshot) GetPath() string {
	return s.path
}

func (s *DeploySnapshot) MakeTableRow() TableRow {
	return &DeployTableRow{}
}

func (s *DeploySnapshot) MakeItem() interface{} {
	return &DeployState{}
}

func (s *DeploySnapshot) AddItem(id string, i interface{}) error {
	state, ok := i.(*DeployState)
	if !ok {
		return fmt.Errorf("type assertion for deploy state failed")
	}
	s.states[id] = state

	return nil
}
