package states

import (
	"fmt"

	"a.yandex-team.ru/infra/spnotifier/ticket"
)

type NannyState struct {
	StartrekerExecution *ticket.StartrekerExecution `json:"startreker_execution"`
}

type NannyTableRow struct {
	ServiceID string `yson:"service_id"`
	State     []byte `yson:"state"`
}

func (r *NannyTableRow) GetState() []byte {
	return r.State
}

func (r *NannyTableRow) GetID() string {
	return r.ServiceID
}

type NannySnapshot struct {
	path   string
	states map[string]*NannyState
}

func (s *NannySnapshot) GetPath() string {
	return s.path
}

func (s *NannySnapshot) MakeTableRow() TableRow {
	return &NannyTableRow{}
}

func (s *NannySnapshot) MakeItem() interface{} {
	return &NannyState{}
}

func (s *NannySnapshot) AddItem(id string, i interface{}) error {
	state, ok := i.(*NannyState)
	if !ok {
		return fmt.Errorf("type assertion for nanny state failed")
	}
	s.states[id] = state

	return nil
}
