package deploy

import (
	"fmt"
	"time"

	"a.yandex-team.ru/infra/spnotifier/processors"
	"a.yandex-team.ru/infra/spnotifier/processors/deploy/evictionrequested"
	"a.yandex-team.ru/infra/spnotifier/providers/pods"
	"a.yandex-team.ru/yp/go/proto/ypapi"
)

type EvictionRequestedTestCase struct{}

func (t *EvictionRequestedTestCase) GetName() string {
	return "deploy_evictionrequested"
}

func CreateEvictionRequestedPod(name string) *pods.DeployPod {
	return &pods.DeployPod{
		StageID: "test",
		Info:    &pods.DeployPodInfo{HostName: name},
		Eviction: &pods.Eviction{
			State: ypapi.EEvictionState_ES_REQUESTED,
		},
	}
}

func CreateEvictionExpiredPod(name string) *pods.DeployPod {
	pod := CreateEvictionRequestedPod(name)
	pod.Eviction.LastUpdated = time.Now().Add(-time.Hour * 48)
	return pod
}

func (t *EvictionRequestedTestCase) Run() (*processors.NotificationProcessorResult, error) {
	pods := map[string]*pods.DeployPod{}
	for i := 1; i <= 4; i++ {
		name := fmt.Sprintf("pod-%d", i)
		pods[name] = CreateEvictionExpiredPod(name)
	}

	p := evictionrequested.Processor{
		StageID: "test",
		Cfg: &evictionrequested.ProcessorConfig{
			DeployURL:                       "https://deploy.yandex-team.ru",
			MaxEvictionExpiredPodsTableSize: 2,
			ManualEvictionPeriod:            time.Hour * 96,
			EvictionExpiredThreshold:        time.Hour * 24,
		},
		Pods: pods,
	}

	return p.Process()
}
