package rendertests

import (
	"fmt"
	"os"
	"path"

	"a.yandex-team.ru/infra/spnotifier/processors"
)

type RenderTestCase interface {
	Run() (*processors.NotificationProcessorResult, error)
	GetName() string
}

const PathPrefix = "../result"

func RunTests(testCases []RenderTestCase) error {
	results := map[string]*processors.NotificationProcessorResult{}
	for _, testCase := range testCases {
		result, err := testCase.Run()
		if err != nil {
			return fmt.Errorf("test case %s failed: %w", testCase.GetName(), err)
		}
		results[testCase.GetName()] = result
	}

	for name, result := range results {
		fileContent := fmt.Sprintf(
			"%s\n\n-----\n\n%s\n\n-----\n\n%s\n",
			result.Header,
			result.Description,
			result.InvocationText,
		)
		fileName := fmt.Sprintf("%s.md", path.Join(PathPrefix, name))
		fd, err := os.Create(fileName)
		if err != nil {
			return fmt.Errorf("file creation failed: %w", err)
		}
		defer fd.Close()

		if _, err := fd.Write([]byte(fileContent)); err != nil {
			return fmt.Errorf("write to file failed: %w", err)
		}
	}

	return nil
}
