package main

import (
	"a.yandex-team.ru/infra/spnotifier/processors"
	"a.yandex-team.ru/infra/spnotifier/rendertests"
	"a.yandex-team.ru/infra/spnotifier/rendertests/deploy"
	"a.yandex-team.ru/infra/spnotifier/rendertests/nanny"
)

type Example struct{}

func (e *Example) Run() (*processors.NotificationProcessorResult, error) {
	return &processors.NotificationProcessorResult{
		Header:         "Example Header",
		Description:    "Example Description",
		InvocationText: "Example Invocation Text",
	}, nil
}

func (e *Example) GetName() string {
	return "example"
}

func main() {
	err := rendertests.RunTests([]rendertests.RenderTestCase{
		&Example{},
		&nanny.EvictionRequestedTestCase{},
		&deploy.EvictionRequestedTestCase{},
	})

	if err != nil {
		panic(err)
	}
}
