package ticket

import (
	"fmt"
	"sync"

	"a.yandex-team.ru/infra/temporal/clients/startrek"
)

// lock to prevent concurrent requests which often result in 429
var mu = sync.Mutex{}

func GetTicketAssigneeByMacro(token, queue, macro string) (string, error) {
	mu.Lock()
	defer mu.Unlock()

	client := startrek.NewClient(&startrek.ClientConfig{
		OauthToken: token,
	})
	tickets, err := client.GetTickets(&startrek.TicketsFilter{
		Filter: startrek.Filter{
			Queue:    queue,
			Status:   startrek.Status{ID: startrek.StatusOpen},
			MacroTag: macro,
		},
	})
	if err != nil {
		return "", err
	}

	switch len(tickets) {
	case 0:
		return "", nil
	case 1:
		assignee := tickets[0].Assignee
		if assignee == nil {
			return "", nil
		}
		return tickets[0].Assignee.ID, nil
	default:
		return "", fmt.Errorf("more than one open ticket for service")
	}
}
