package yt

import (
	"context"
	"fmt"

	"golang.org/x/sync/errgroup"

	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/yt/go/yt"
)

type YtRowInfo struct {
	YtPath string
	Value  interface{}
}

type Uploader struct {
	Client yt.Client
	Ch     chan *YtRowInfo

	errg errgroup.Group
}

func (u *Uploader) upload(ctx context.Context, ytPath string, values []interface{}) error {
	return u.Client.InsertRows(ctx, ypath.Path(ytPath), values, nil)
}

func (u *Uploader) consume(ctx context.Context) error {
	rows := map[string][]interface{}{} // yt path: rows

	for row := range u.Ch {
		rows[row.YtPath] = append(rows[row.YtPath], row.Value)
	}

	for ytPath, values := range rows {
		err := u.upload(ctx, ytPath, values)
		if err != nil {
			return fmt.Errorf("failed to upload %s: %w", ytPath, err)
		}
	}

	return nil
}

func (u *Uploader) Start() {
	u.errg.Go(func() error { return u.consume(context.Background()) })
}

func (u *Uploader) Wait() error {
	return u.errg.Wait()
}
