package main

import (
	"context"
	"log"
	"os"
	"time"

	"a.yandex-team.ru/infra/spnotifier/clients/errorbooster"
)

func getEnv(name string) string {
	value := os.Getenv(name)
	if value == "" {
		log.Fatalf("%s must be set", name)
	}
	return value
}

func main() {
	nannyToken := getEnv("NANNY_TOKEN")
	ypToken := getEnv("YP_TOKEN")
	ytToken := getEnv("YT_TOKEN")
	temporalToken := getEnv("TEMPORAL_TOKEN")
	abcToken := getEnv("ABC_TOKEN")
	logbrokerToken := getEnv("LOGBROKER_TOKEN")
	startrekerToken := getEnv("ST_TOKEN")

	cfg, err := getConfig()
	if err != nil {
		panic(err)
	}

	ctx := context.Background()

	ebClient, err := errorbooster.NewClient(cfg.ErrorBooster, logbrokerToken, ctx)
	if err != nil {
		panic(err)
	}
	defer ebClient.Close()

	ctrl := Controller{
		ctx:             ctx,
		cfg:             cfg,
		ebClient:        ebClient,
		ypToken:         ypToken,
		ytToken:         ytToken,
		nannyToken:      nannyToken,
		temporalToken:   temporalToken,
		abcToken:        abcToken,
		startrekerToken: startrekerToken,
	}

	for {
		log.Println("starting iteration")
		timer := time.NewTimer(cfg.IterationPeriod)
		err = ctrl.run()
		if err != nil {
			log.Printf("iteration failed: %v\n", err)
			if err := ebClient.Send(err.Error()); err != nil {
				log.Printf("failed to send to errorbooster: %v", err)
			}
		}
		log.Println("iteration finished")

		<-timer.C
	}
}
