#!/usr/bin/env python

import os

from sys import argv
from porto import Connection
from porto.exceptions import VolumeAlreadyExists


class open_connection(object):

  def __init__(self, *args, **kwargs):
    self.args = args
    self.kwargs = kwargs

  def __enter__(self):
    self.connection = Connection(*self.args, **self.kwargs)
    return self.connection

  def __exit__(self, type, value, traceback):
    self.connection.disconnect()


def create_tmpfs(path, size):
    with open_connection(timeout=120) as conn:
        if not os.path.exists(path):
            os.mkdir(path, 0775)
        try:
            conn.CreateVolume(path=path, backend='tmpfs', space_limit=size)
        except VolumeAlreadyExists as e:
            pass

create_tmpfs(argv[1], argv[2])
