#!/usr/bin/env bash

JAR_FILE=${1:-/opt/stagectl/stage_controller.jar}
VMOPTIONS_FILE=${2:-/opt/stagectl/application.vmoptions}
GC_LOG_DIR=${GC_LOG_DIR:-/var/log/stagectl/gc}
TMPFS_SIZE=${TMPFS_SIZE:-100M}

set -eu
set -o pipefail

/opt/stagectl/create_tmpfs.py "${GC_LOG_DIR}" "${TMPFS_SIZE}"
/opt/stagectl/jdk_mux.sh \
    /opt/jdk "${VMOPTIONS_FILE}" java -jar "${JAR_FILE}" /opt/stagectl/application.conf
