import argparse

from yp.client import YpClient
from yp.client import find_token
import yt.yson as yson
import time

page_size = 1 << 14


def select_all(client, object_type, selectors, filter=None):

    result = []
    options = {}
    while True:
        objects = client.select_objects(object_type, selectors=selectors, limit=page_size, options=options,
                                        filter=filter, enable_structured_response=True)

        rows = objects["results"]
        for data in rows:
            result.append([item["value"] for item in data])

        if len(rows) < page_size:
            break

        options["continuation_token"] = objects["continuation_token"]

    return result


def set_fields(client, object_type, set_updates, remove_updates, batch_size, filter=None, sleep=None):

    def chunks(ids, size):
        return [ids[i:i + size] for i in range(0, len(ids), size)]

    updates = [{"path": path, "value": yson._loads_from_native_str(value)} for (path, value) in set_updates] if len(set_updates) > 0 else None
    removes = [{"path": remove[0], "force": True} for remove in remove_updates] if len(remove_updates) > 0 else None

    objects = select_all(client, object_type, ["/meta/id"], filter)
    print(f"loaded {len(objects)} {object_type} objects")

    batches = chunks(objects, batch_size)

    offset = 0
    for batch in batches:
        if sleep and offset:
            time.sleep(sleep)

        try:
            client.update_objects([{
                "object_type" : object_type,
                "object_id" : row[0],
                "set_updates" : updates,
                "remove_updates" : removes
            } for row in batch])

            for row in batch:
                print(f"{offset}: {row[0]}")
                offset += 1

        except Exception as error:
            offset += len(batch)
            print(f"Failed to update {object_type}(s): {batch}\n{error}")


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--address", default="sas-test")
    parser.add_argument("--set", action="append", nargs=2, default=[])
    parser.add_argument("--remove", action="append", nargs=1, default=[])
    parser.add_argument("--object_type")
    parser.add_argument("--filter")
    parser.add_argument("--batch", default=128)
    parser.add_argument("--sleep", default=0.0)
    return parser.parse_args()


def main():
    args = parse_args()
    client = YpClient(args.address, config={"token": find_token()})
    set_fields(client, args.object_type, args.set, args.remove, int(args.batch), args.filter, float(args.sleep))


if __name__ == "__main__":
    main()
