package ru.yandex.infra.stage;


public final class AclPrefixFilter implements AclFilter {
    private final String prefix;

    public AclPrefixFilter(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean isProjectIdMatches(String subject, String projectId) {
        return projectId != null && subject!= null
                && subject.matches('^' + prefix + projectId + "\\.[A-Z]+_*[A-Z]*$");
    }

    @Override
    public boolean isSubjectMatches(String subject) {
        return subject != null && subject.startsWith(prefix);
    }
}
