package ru.yandex.infra.stage;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.infra.stage.dto.DeployUnitOverrides;
import ru.yandex.infra.stage.dto.DeployUnitOverrides.PerClusterOverrides;
import ru.yandex.yp.client.api.TDeployUnitSpec;
import ru.yandex.yp.client.api.TDeployUnitSpec.TReplicaSetDeploy.TPerClusterSettings;
import ru.yandex.yp.client.api.TStageSpec;

public class DeployUnitsOverridesPatcher implements StageSpecPatcher {
    private static final String MCRS_KEY = "multi";

    private final Map<String, DeployUnitOverrides> deployUnitOverrides;

    public DeployUnitsOverridesPatcher(Map<String, DeployUnitOverrides> deployUnitOverrides) {
        this.deployUnitOverrides = deployUnitOverrides;
    }

    @Override
    public void patch(TStageSpec.Builder specBuilder) {
        Map<String, TDeployUnitSpec> deployUnitsToOverride = specBuilder.getDeployUnitsMap().entrySet().stream()
                .filter(entry -> deployUnitOverrides.containsKey(entry.getKey()))
                .filter(entry -> entry.getValue().getRevision() == deployUnitOverrides.get(entry.getKey()).getRevisionToOverride())
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

        deployUnitsToOverride.forEach((duId, duSpec) -> {
            TDeployUnitSpec.Builder duBuilder = duSpec.toBuilder();
            DeployUnitOverrides overrides = deployUnitOverrides.get(duId);
            if (duBuilder.hasMultiClusterReplicaSet()
                    && overrides.getPerClusterOverrides().keySet().equals(Set.of(MCRS_KEY)))
            {
                duBuilder.getMultiClusterReplicaSetBuilder().getReplicaSetBuilder().getDeploymentStrategyBuilder()
                        .setMaxUnavailable(overrides.getPerClusterOverrides().get(MCRS_KEY).getMaxUnavailable());
                specBuilder.putDeployUnits(duId, duBuilder.build());
            } else if (duBuilder.hasReplicaSet()) {

                Map<String, PerClusterOverrides> perClusterOverrides = overrides.getPerClusterOverrides();
                Map<String, TPerClusterSettings> perClusterSettings = duBuilder.getReplicaSetBuilder().getPerClusterSettingsMap();
                perClusterSettings.forEach((cluster, settings) -> {
                    if (perClusterOverrides.containsKey(cluster)) {
                        TPerClusterSettings.Builder settingsBuilder = settings.toBuilder();
                        settingsBuilder.getDeploymentStrategyBuilder().setMaxUnavailable(
                                perClusterOverrides.get(cluster).getMaxUnavailable());
                        duBuilder.getReplicaSetBuilder().putPerClusterSettings(cluster, settingsBuilder.build());
                    }
                });
                specBuilder.putDeployUnits(duId, duBuilder.build());
            }
        });
    }
}
