package ru.yandex.infra.stage;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class GlobalContext {
    public static final GlobalContext EMPTY = new GlobalContext(Collections.emptySet());

    private final Set<String> disabledClusters;

    public GlobalContext(Set<String> disabledClusters) {
        this.disabledClusters = disabledClusters;
    }

    public Set<String> getDisabledClusters() {
        return disabledClusters;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GlobalContext that = (GlobalContext) o;
        return Objects.equals(disabledClusters, that.disabledClusters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(disabledClusters);
    }
}
